       IDENTIFICATION DIVISION.
       PROGRAM-ID. CUSTINFO.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.

           COPY "MOBILECOBOL.WS".

       01 CUST-INFO.
           03 CUST-NAME   PIC X(80).
           03 CUST-EMAIL  PIC X(80).
           03 CUST-NOTES  PIC X(2000).
           03 CUST-ACTIVE PIC X(10).
           03 CUST-DOB    PIC X(20).

       PROCEDURE DIVISION.
       MAIN-LOGIC.
           PERFORM CREATE-PAGE.
           PERFORM HANDLE-EVENTS
               UNTIL MC-EVENT = "QUIT".
           GOBACK.

       HANDLE-EVENTS.
           CALL MC USING GETEVENT MC-EVENTINFO.
           EVALUATE MC-EVENT-CONTROL
               WHEN "SAVEBUTTON"  PERFORM SAVE-CUST
               WHEN "CLEARBUTTON" PERFORM CLEAR-INFO
           END-EVALUATE.

       SAVE-CUST.
           CALL MC USING GETPROP 
               "Name=NAMEENTRY;Property=Text|" CUST-NAME.
           CALL MC USING GETPROP 
               "Name=EMAILENTRY;Property=Text|" CUST-EMAIL.
           CALL MC USING GETPROP 
               "Name=NOTESEDITOR;Property=Text|" CUST-NOTES.
           CALL MC USING GETPROP 
               "Name=DOBPICKER;Property=Date|" CUST-DOB.
           CALL MC USING GETPROP 
               "Name=ACTIVESWITCH;Property=IsToggled|" CUST-ACTIVE.
           CALL MC USING SETPROP "Name=STATUSLABEL;Text=Saved|".
           CALL MC USING DISPLAYALERT "Success|" 
                                      "Customer Saved|" 
                                      "OK|".

       CLEAR-INFO.
           CALL MC USING SETPROP "Name=NAMEENTRY;Text=|".
           CALL MC USING SETPROP "Name=EMAILENTRY;Text=|".
           CALL MC USING SETPROP "Name=NOTESEDITOR;Text=|".
           CALL MC USING SETPROP "Name=ACTIVESWITCH;IsToggled=false|".
           CALL MC USING SETPROP "Name=STATUSLABEL;Text=|".
           CALL MC USING SETPROP "Name=DOBPICKER;Date=DateTime.Now|".

       CREATE-PAGE.
           CALL MC USING CREATEPAGE "Name=Page1|".
           PERFORM ADD-SCROLLING-STACK-LAYOUT.
           PERFORM ADD-TOP-PROMPT.
           PERFORM ADD-CONTROLS.
           CALL MC USING SHOWPAGE.

       ADD-SCROLLING-STACK-LAYOUT.
           CALL MC USING ADDCHILD "Type=ScrollView|".
           CALL MC USING ADDCHILD 
               "Type=StackLayout;Padding=20;Spacing=15|".            

       ADD-TOP-PROMPT.
           CALL MC USING ADDCHILD  
               "Type=Label;FontSize=24;Text=Enter Customer Info|".
           CALL MC USING SETPROP       
                            "FontAttributes=Bold|".

       ADD-CONTROLS.
           PERFORM ADD-IMAGE.
           CALL MC USING ADDCHILD  
               "Type=Entry;Name=NAMEENTRY;Placeholder=Name|".
           CALL MC USING ADDCHILD  
               "Type=Entry;Name=EMAILENTRY;Placeholder=Email|".
           CALL MC USING SETPROP        "Keyboard=Email|".
           CALL MC USING ADDCHILD  "Type=Label;Text=Date of Birth|".
           CALL MC USING ADDCHILD  
               "Type=DatePicker;Name=DOBPICKER|".
           CALL MC USING ADDCHILD  "Type=Label;Text=Notes|".
           CALL MC USING ADDCHILD  
               "Type=Editor;Name=NOTESEDITOR;Placeholder=Notes|".
           CALL MC USING SETPROP    "AutoSize=TextChanges|".
           PERFORM ADD-LABEL-AND-SWITCH.
           CALL MC USING ADDCHILD  
               "Type=Label;Name=STATUSLABEL;TextColor=Blue|".
           PERFORM ADD-BUTTONS.

       ADD-IMAGE.
           CALL MC USING UPLOADFILE "FileName=custinfo.png|".
           CALL MC USING ADDCHILD  
               "Type=Image;Source=custinfo.png|".
           CALL MC USING SETPROP  
               "HeightRequest=200;WidthRequest=200|".

       ADD-LABEL-AND-SWITCH.
           CALL MC USING ADDCHILD  "Type=HorizontalStackLayout|".
           CALL MC USING ADDCHILD  "Type=Label;Text=Active?|".
           CALL MC USING ADDCHILD  "Type=Switch;Name=ACTIVESWITCH|".
           CALL MC USING ENDCONTAINER.

       ADD-BUTTONS.
           CALL MC USING ADDCHILD  
               "Type=HorizontalStackLayout;Spacing=10|".
           CALL MC USING ADDCHILD  
               "Type=Button;Name=SAVEBUTTON;Text=Save;Event=Clicked|".
           CALL MC USING SETPROP        
               "BackgroundColor=Green;TextColor=White|".
           CALL MC USING ADDCHILD  
               "Type=Button;Name=CLEARBUTTON;Text=Clear;Event=Clicked|".
           CALL MC USING SETPROP        
               "BackgroundColor=Gray;TextColor=White|".
           CALL MC USING ENDCONTAINER.



