      **************************************
      * Demonstration of one approach to moving from a list to detail
      * and back to the list
      **************************************
       IDENTIFICATION DIVISION.
       PROGRAM-ID. MASTERDETAIL.
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.

           COPY "MOBILECOBOL.WS".

      * used to retrieve the Name property of the selected entry
       01 SEL-Name PIC X(40).

      * used for building arguments
       01 ARG-VALUE PIC X(1000).

       01 NUM-OF-ITEMS      PIC 9(4) VALUE 5.

       01 ITEM-SUB          PIC 9(4).

      * Data used for list and detail, could come from a file instead
       01 DATA-AREA.
           02 RAW-DATA.
      ***** FEATURE 1
               03 FILLER PIC X(30) VALUE "DevTeam1.JPG".
               03 FILLER PIC X(30) VALUE "Simplicity".
               03 FILLER PIC X(49) VALUE 
                  "You don't need to learn anything new to create a ".
               03 FILLER PIC X(48) VALUE
                  "great mobile app.  All you need is your current ".
               03 FILLER PIC X(46) VALUE
                  "compiler and Mobile COBOL.  With a few simple ".
               03 FILLER PIC X(49) VALUE
                  "calls you will have your first mobile app up and ".
               03 FILLER PIC X(31) VALUE
                  "running in minutes, not months!".
               03 FILLER PIC X(177) VALUE SPACE.
      ***** ITEM 2
               03 FILLER PIC X(30) VALUE "TiredCoder1.JPG".
               03 FILLER PIC X(30) VALUE "No mobile coding".
               03 FILLER PIC X(50) VALUE
                  "Why spend months mastering new coding techniques? ".
               03 FILLER PIC X(47) VALUE
                  "With Mobile COBOL you can immediately produce ".
               03 FILLER PIC X(43) VALUE
                  "mobile apps with the language, code, and ".
               03 FILLER PIC X(37) VALUE
                  "approaches you have already mastered.".
               03 FILLER PIC X(223) VALUE SPACE.
      ***** ITEM 3
               03 FILLER PIC X(30) VALUE "CODER1.JPG".
               03 FILLER PIC X(30) VALUE "Low code, pure COBOL".
               03 FILLER PIC X(48) VALUE
                  "Low code approaches work great for mobile apps, ".
               03 FILLER PIC X(46) VALUE
                  "and wny not let COBOL be your low code mobile ".
               03 FILLER PIC X(49) VALUE
                  "syntax rather than starting over with a new one? ".
               03 FILLER PIC X(257) VALUE SPACE.
      ***** ITEM 4
               03 FILLER PIC X(30) VALUE "server1.jpg".
               03 FILLER PIC X(30) VALUE "Everything on the server".
               03 FILLER PIC X(42) VALUE 
                   "Mobile COBOL eliminates all mobile device ".
               03 FILLER PIC X(48) VALUE
                   "programming. Really!  Everything is done on the ".
               03 FILLER PIC X(48) VALUE
                   "server.  That means all updates are immediately ".
               03 FILLER PIC X(45) VALUE
                   "in effect and there is no need to go through ".
               03 FILLER PIC X(22) VALUE
                   "the App Store process.".
               03 FILLER PIC X(195) VALUE SPACE.
      ***** ITEM 5
               03 FILLER PIC X(30) VALUE "Meeting1.jpg".
               03 FILLER PIC X(30) VALUE "iOS, Android, Windows, Mac".
               03 FILLER PIC X(49) VALUE 
                 "One source, all in COBOL, puts your app wherever ".
               03 FILLER PIC X(49) VALUE 
                 "you want it.  Leveraging the portability of .Net ".
               03 FILLER PIC X(49) VALUE 
                 "MAUI (without the complex programming) gets your ".
               03 FILLER PIC X(15) VALUE 
                 "app everywhere.".
               03 FILLER PIC X(238) VALUE 
                "One source, all in COBOL, puts your app wherever ".
               
           02 DATA-TABLE REDEFINES RAW-DATA.
               03 ITEM-ENTRY OCCURS 5 TIMES.
                   05 ITEM-IMAGE             PIC X(30).
                   05 ITEM-SHORT-INFO        PIC X(30).
                   05 ITEM-LONG-INFO         PIC X(400).

       PROCEDURE DIVISION.
       MAIN-LOGIC.
           PERFORM CREATE-MASTER-PAGE.
           PERFORM HANDLE-EVENTS
               UNTIL MC-EVENT = "QUIT".
           GOBACK.

       HANDLE-EVENTS.
           CALL MC USING GETEVENT MC-EVENTINFO.
           EVALUATE MC-EVENT
               WHEN "SelectionChanged" PERFORM DISPLAY-DETAIL
           END-EVALUATE.


      *********************
      * master page
      *********************

       CREATE-MASTER-PAGE.
           CALL MC USING CREATEPAGE "Name=Master|".
           PERFORM ADD-GRID.
           PERFORM ADD-TITLE.
           PERFORM ADD-LISTVIEW.
           PERFORM ADD-ITEMS-TO-LISTVIEW.
      **** Items must be added to the listview before the template is added
           PERFORM ADD-TEMPLATE-TO-LISTVIEW.
           PERFORM SHOW-PAGE.

       ADD-GRID.
           CALL MC USING ADDCHILD  "Type=Grid;Name=Features|".
           CALL MC USING ADDCHILD 
               "Type=RowDefinition;Height=GridLength.Auto|".
           CALL MC USING ADDCHILD 
               "Type=RowDefinition;Height=GridLength.Star|".

       ADD-TITLE.
           CALL MC USING ADDCHILD  
               "Type=Label;FontSize=24;Text=Mobile COBOL Features|".
           PERFORM SET-BOLD-FONT.
    
       ADD-LISTVIEW.
           CALL MC USING ADDCHILD 
              "Type=CollectionView;Name=FeaturesList|".
           CALL MC USING SETPROP  "Event=SelectionChanged|".
           CALL MC USING SETPROP "SelectionMode=Single|".
           CALL MC USING DOMETHODNORET
           "Name=Features;Method=SetRow;ObjName=FeaturesList;RowNum=1|".

       ADD-TEMPLATE-TO-LISTVIEW.
           CALL MC USING CREATETEMPLATE.
           CALL MC USING ADDCHILD  "Type=VerticalStackLayout|".
           CALL MC USING SETPROP    "Padding=10|".
           CALL MC USING ADDCHILD  "Type=Label;FontSize=20|".
           CALL MC USING SETPROP    "Binding=Text to Desc|".
           CALL MC USING ADDCHILD  "Type=Image|".
           CALL MC USING SETPROP    "Binding=Source to ImagePath|".
           PERFORM END-LAYOUT.
           PERFORM END-TEMPLATE.

       ADD-ITEMS-TO-LISTVIEW.
           PERFORM UPLOAD-IMAGES.
           PERFORM CREATE-ITEMS.
           
       UPLOAD-IMAGES.
           PERFORM VARYING ITEM-SUB FROM 1 BY 1
             UNTIL ITEM-SUB > NUM-OF-ITEMS
               MOVE SPACE TO ARG-VALUE
               STRING "FileName="
                      ITEM-IMAGE (ITEM-SUB) 
                      "|" 
                   DELIMITED BY SIZE INTO ARG-VALUE
               CALL MC USING UPLOADFILE ARG-VALUE
           END-PERFORM.

       CREATE-ITEMS.
           PERFORM VARYING ITEM-SUB FROM 1 BY 1
             UNTIL ITEM-SUB > NUM-OF-ITEMS
               MOVE SPACE TO ARG-VALUE
               STRING "Type=ExpandoObject;Name=Item"
                       ITEM-SUB
                      ";ImagePath="
                      ITEM-IMAGE (ITEM-SUB) 
                      ";Desc=" 
                      ITEM-SHORT-INFO (ITEM-SUB)  
                      "|" 
                   DELIMITED BY SIZE INTO ARG-VALUE
               CALL MC USING ADDITEM ARG-VALUE
           END-PERFORM.


      *********************
      * detail page
      *********************

       DISPLAY-DETAIL.
           PERFORM GET-SELECTION.
           CALL MC USING CREATEPAGE "Name=Detail|".
           PERFORM ADD-STACKLAYOUT. 
           PERFORM ADD-DETAIL-HEADER.
           PERFORM ADD-DETAIL-IMAGE.
           PERFORM ADD-DETAIL-TEXT.
           PERFORM SHOW-PAGE.
   
       ADD-DETAIL-HEADER.
           CALL MC USING ADDCHILD  "Type=Label;FontSize=20|".
           STRING "Text=" ITEM-SHORT-INFO (MC-SEL-INDEX + 1) "|"
               DELIMITED BY SIZE INTO ARG-VALUE.
           CALL MC USING SETPROP ARG-VALUE.

       ADD-DETAIL-IMAGE.
           CALL MC USING ADDCHILD  "Type=Image;HeightRequest=200|".
           MOVE SPACE TO ARG-VALUE.
           STRING "Source=" ITEM-IMAGE (MC-SEL-INDEX + 1) "|"
               DELIMITED BY SIZE INTO ARG-VALUE.
           CALL MC USING SETPROP ARG-VALUE.

       ADD-DETAIL-TEXT.
           MOVE SPACE TO ARG-VALUE.
           STRING "Type=Label;FontSize=16;Text="
                  ITEM-LONG-INFO (MC-SEL-INDEX + 1)
                  "|" DELIMITED BY SIZE INTO ARG-VALUE.
           CALL MC USING ADDCHILD ARG-VALUE.

       GET-SELECTION.
      **** this gets a 0 relative numeric index of the selected item
           CALL MC USING GETPROP 
               "Name=FeaturesList;Property=SelectedIndex|" 
               MC-SEL-INDEX.      
      **** this gets the Name property of the selected item     
      *    if loading from a file this could be the record key
      *     CALL MC USING GETPROP 
      *         "Name=FeaturesList;Property=SelectedName|" 
      *         SEL-Name.


      ********************************************
      * re-usable routines shared by both pages
      ********************************************
       ADD-STACKLAYOUT.
           CALL MC USING ADDCHILD  
               "Type=StackLayout;Padding=20;Spacing=15|".     

       SHOW-PAGE.
           CALL MC USING SHOWPAGE.

       SET-BOLD-FONT.
           CALL MC USING SETPROP     "FontAttributes=Bold|".

       END-LAYOUT.
           CALL MC USING ENDCONTAINER.

       END-TEMPLATE.
           CALL MC USING ENDTEMPLATE.


